/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import mlsoft.mct.MlEventMulticaster;
import mlsoft.mct.MlGrid;
import mlsoft.mct.MlGridCell;
import mlsoft.mct.MlGridCellValues;
import mlsoft.mct.MlGridColumn;
import mlsoft.mct.MlGridPos;
import mlsoft.mct.MlGridRow;
import mlsoft.mct.MlIconMaker;
import mlsoft.mct.MlResource;
import mlsoft.mct.MlResources;
import mlsoft.mct.MlTreeCell;
import mlsoft.mct.MlTreeEvent;
import mlsoft.mct.MlTreeEventHandler;
import mlsoft.mct.MlTreeListener;
import mlsoft.mct.MlTreeResourceMap;
import mlsoft.mct.MlTreeRowDefinition;
import mlsoft.mct.MlTreeRowValues;

public class MlTree
extends MlGrid {
    private static MlTreeResourceMap _treeResMap;
    protected int _rowLevel;
    protected boolean _rowExpands;
    protected boolean _rowIsExpanded;
    protected boolean _defaultImagesCreated;
    protected Image _fileImage;
    protected Image _folderOpenImage;
    protected Image _folderImage;
    protected byte[] _linesData;
    protected int _linesMaxLevel;
    protected int _linesSize;
    protected boolean _recalcTreeWidth;
    private static final long firstRowBit = 3L;
    protected static final long rowLevel_BIT = 8L;
    protected static final long rowExpands_BIT = 16L;
    protected static final long rowIsExpanded_BIT = 32L;
    protected static final long rowValueLast_BIT = 3L;
    protected MlTreeEventHandler _handler;
    protected MlTreeListener _treeListener;
    protected int _levelSpacing;
    protected Color _lineColor;
    protected Color _pmColor;

    private static synchronized void initResourceMap() {
        if (_treeResMap != null) {
            return;
        }
        _treeResMap = new MlTreeResourceMap();
    }

    public MlTree() {
        MlTree.initResourceMap();
        this._resourceMap = _treeResMap;
        this.initTreeProperties();
        this._defaultImagesCreated = false;
        this._linesData = null;
        this._linesSize = 0;
        this._recalcTreeWidth = false;
        this._defRowValues = new MlTreeRowValues();
        this.addColumns(1, -1, 1);
        MlResources mlResources = new MlResources();
        mlResources.add("cellDefaults", true);
        mlResources.add("column", 0);
        mlResources.add("cellType", "ICON_CELL");
        this.setValues(mlResources);
        mlResources.clear();
        mlResources.add("cellDefaults", true);
        mlResources.add("cellBackground", "#FFFFFF");
        mlResources.add("cellTopBorderType", "BORDER_NONE");
        mlResources.add("cellBottomBorderType", "BORDER_NONE");
        mlResources.add("cellLeftBorderType", "BORDER_NONE");
        mlResources.add("cellRightBorderType", "BORDER_NONE");
        this.setValues(mlResources);
        this._handler = new MlTreeEventHandler(this);
        this.addMouseListener(this._handler);
        this.addMlGridListener(this._handler);
    }

    protected synchronized boolean preLayout(boolean bl) {
        MlTreeRowValues mlTreeRowValues;
        if (!this._vertVisChangedHint) {
            return false;
        }
        this._vertVisChangedHint = false;
        MlResources mlResources = new MlResources();
        int n = -1;
        int n2 = 0;
        this._layoutFrozen = true;
        int n3 = 0;
        while (n3 < this._rowCount) {
            mlTreeRowValues = (MlTreeRowValues)this.getRow(1, n3).getValues();
            if (mlTreeRowValues.level > n2) {
                n2 = mlTreeRowValues.level;
            }
            if (n != -1 && mlTreeRowValues.level > n) {
                if (mlTreeRowValues.height != 0) {
                    mlResources.clear();
                    mlResources.add("row", n3);
                    mlResources.add("rowHeight", 0);
                    this.setValues(mlResources);
                }
            } else {
                n = mlTreeRowValues.expands && !mlTreeRowValues.isExpanded ? mlTreeRowValues.level : -1;
                if (mlTreeRowValues.height == 0) {
                    mlResources.clear();
                    mlResources.add("row", n3);
                    mlResources.add("rowHeight", 1);
                    this.setValues(mlResources);
                }
            }
            ++n3;
        }
        this._layoutFrozen = false;
        this._linesMaxLevel = n2;
        if (this._rowCount == 0) {
            return bl;
        }
        int n4 = n2 + 1;
        int n5 = n4 * this._rowCount;
        if (this._linesSize < n5) {
            this._linesSize = n5;
            this._linesData = new byte[n5];
        }
        byte[] byArray = this._linesData;
        int n6 = -1;
        int n7 = n5 - n4;
        n3 = this._rowCount - 1;
        while (n3 >= 0) {
            mlTreeRowValues = (MlTreeRowValues)this.getRow(1, n3).getValues();
            if (mlTreeRowValues.height == 0) {
                n7 -= n4;
            } else {
                int n8 = 0;
                while (n8 < mlTreeRowValues.level - 1) {
                    byArray[n7 + n8] = n6 != -1 && (byArray[n6 + n8] == 76 || byArray[n6 + n8] == 73 || byArray[n6 + n8] == 69) ? 73 : 32;
                    ++n8;
                }
                if (mlTreeRowValues.level > 0) {
                    byArray[n7 + n8] = n6 != -1 && (byArray[n6 + n8] == 76 || byArray[n6 + n8] == 73 || byArray[n6 + n8] == 69) ? 69 : 76;
                    ++n8;
                }
                byArray[n7 + n8] = 79;
                ++n8;
                while (n8 < n4) {
                    byArray[n7 + n8] = 32;
                    ++n8;
                }
                n6 = n7;
                n7 -= n4;
            }
            --n3;
        }
        if (n6 != -1) {
            n3 = 0;
            while (n3 < n4) {
                if (byArray[n6 + n3] == 76) {
                    byArray[n6 + n3] = 45;
                } else if (byArray[n6 + n3] == 69) {
                    byArray[n6 + n3] = 80;
                }
                ++n3;
            }
        }
        return bl;
    }

    protected boolean posIsIndicator(int n, int n2) {
        MlGridPos mlGridPos = this.XYToRowColumn(n, n2);
        if (mlGridPos == null) {
            return false;
        }
        if (mlGridPos.rowType != 1 || mlGridPos.columnType != 1 || mlGridPos.column != 0) {
            return false;
        }
        Rectangle rectangle = this.rowColumnToXY(1, mlGridPos.row, 1, 0, false);
        if (rectangle == null) {
            return false;
        }
        int n3 = this._levelSpacing;
        MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)this.getRow(1, mlGridPos.row).getValues();
        int n4 = rectangle.x + (mlTreeRowValues.level - 1) * n3 * 2 + n3 - 6;
        int n5 = n4 + 13;
        int n6 = rectangle.y + rectangle.height / 2 - 6;
        int n7 = n6 + 13;
        return n <= n5 && n >= n4 && n2 <= n7 && n2 >= n6;
    }

    protected synchronized void changeRowState(int n, AWTEvent aWTEvent, boolean bl, boolean bl2, boolean bl3) {
        MlGridRow mlGridRow = this.getRow(1, n);
        if (mlGridRow == null) {
            return;
        }
        MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
        if (!mlTreeRowValues.expands) {
            return;
        }
        if (!bl2 && bl == mlTreeRowValues.isExpanded) {
            return;
        }
        if (bl2) {
            bl = !mlTreeRowValues.isExpanded;
        }
        int n2 = bl ? 5020 : 5019;
        MlResources mlResources = new MlResources();
        mlResources.add("row", n);
        mlResources.add("rowIsExpanded", bl);
        this.setValues(mlResources);
        if (bl3) {
            this.notifyEvent(n2, 1, n, 4, 0, aWTEvent, null);
        }
    }

    protected MlGridCell newCell(int n, int n2) {
        if (this.rowPosToType(n) != 1 || this.colPosToType(n2) != 1 || this.colPosToTypePos(1, n2) != 0) {
            return super.newCell(n, n2);
        }
        MlTreeCell mlTreeCell = new MlTreeCell();
        MlGridColumn mlGridColumn = (MlGridColumn)this._colArray.get(n2);
        MlGridCellValues mlGridCellValues = mlGridColumn.getDefaultCellValues();
        if (mlGridCellValues == null) {
            mlGridCellValues = this._defCellValues;
        }
        mlTreeCell.setValues(mlGridCellValues);
        return mlTreeCell;
    }

    protected MlGridRow newRow() {
        return new MlGridRow(this, new MlTreeRowValues((MlTreeRowValues)this._defRowValues));
    }

    protected long getRowValueMask(int n, long l) {
        l = super.getRowValueMask(n, l);
        switch (n) {
            case 271: {
                l |= 8L;
                break;
            }
            case 269: {
                l |= 0x10L;
                break;
            }
            case 270: {
                l |= 0x20L;
            }
        }
        return l;
    }

    protected Object getRowValueByIndex(MlGridRow mlGridRow, int n) {
        Object object = super.getRowValueByIndex(mlGridRow, n);
        if (object != null) {
            return object;
        }
        MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
        switch (n) {
            case 271: {
                return new Integer(mlTreeRowValues.level);
            }
            case 269: {
                return new Boolean(mlTreeRowValues.expands);
            }
            case 270: {
                return new Boolean(mlTreeRowValues.isExpanded);
            }
        }
        return null;
    }

    protected boolean setRowValues(MlGridRow mlGridRow, long l) {
        boolean bl = super.setRowValues(mlGridRow, l);
        if (mlGridRow == null) {
            MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)this._defRowValues;
            if ((l & 8L) > 0L) {
                mlTreeRowValues.level = this._rowLevel;
            }
            if ((l & 0x10L) > 0L) {
                mlTreeRowValues.expands = this._rowExpands;
            }
            if ((l & 0x20L) > 0L) {
                mlTreeRowValues.isExpanded = this._rowIsExpanded;
            }
            return false;
        }
        MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
        if ((l & 1L) > 0L && bl) {
            this._recalcTreeWidth = true;
        }
        if ((l & 8L) > 0L) {
            mlTreeRowValues.level = this._rowLevel;
            this._recalcTreeWidth = true;
            this._vertVisChangedHint = true;
            bl = true;
        }
        if ((l & 0x10L) > 0L) {
            mlTreeRowValues.expands = this._rowExpands;
            this._vertVisChangedHint = true;
            bl = true;
        }
        if ((l & 0x20L) > 0L) {
            mlTreeRowValues.isExpanded = this._rowIsExpanded;
            this._vertVisChangedHint = true;
            bl = true;
        }
        return bl;
    }

    protected synchronized void setSubValues(MlResources mlResources) {
        int n = mlResources.getCount();
        int n2 = 0;
        while (n2 < n) {
            MlResource mlResource = mlResources.getResource(n2);
            if (!mlResource.applied && mlResource.converted) {
                int n3 = 0;
                if (mlResource.type == 1) {
                    n3 = (Integer)mlResource.value;
                }
                boolean bl = false;
                if (mlResource.type == 3) {
                    bl = (Boolean)mlResource.value;
                }
                switch (mlResource.index) {
                    case 271: {
                        this._rowLevel = n3;
                        break;
                    }
                    case 269: {
                        this._rowExpands = bl;
                        break;
                    }
                    case 270: {
                        this._rowIsExpanded = bl;
                    }
                }
            }
            ++n2;
        }
        super.setSubValues(mlResources);
    }

    protected boolean setCellValuesResize(MlGridRow mlGridRow, MlGridColumn mlGridColumn, MlGridCell mlGridCell, long l) {
        boolean bl = super.setCellValuesResize(mlGridRow, mlGridColumn, mlGridCell, l);
        if (mlGridColumn.getPos() == this._headingColCount && mlGridRow.getPos() >= this._headingRowCount && mlGridRow.getPos() < this._headingRowCount + this._rowCount) {
            MlTreeRowValues mlTreeRowValues;
            if ((l & 0x80L) > 0L) {
                mlGridRow.heightChanged();
                mlGridColumn.widthChanged();
                mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
                mlTreeRowValues.stringWidthValid = false;
                bl = true;
            }
            if ((l & 0x20000L) > 0L) {
                mlGridColumn.widthChanged();
                mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
                mlTreeRowValues.stringWidthValid = false;
                bl = true;
            }
        }
        return bl;
    }

    protected synchronized void setValuesConverted(MlResources mlResources) {
        super.setValuesConverted(mlResources);
        boolean bl = false;
        boolean bl2 = false;
        int n = mlResources.getCount();
        int n2 = 0;
        while (n2 < n) {
            MlResource mlResource = mlResources.getResource(n2);
            if (!mlResource.applied && mlResource.converted) {
                int n3 = 0;
                if (mlResource.type == 1) {
                    n3 = (Integer)mlResource.value;
                }
                switch (mlResource.index) {
                    case 171: {
                        this._pmColor = (Color)mlResource.value;
                        bl2 = true;
                        mlResource.applied = true;
                        break;
                    }
                    case 169: {
                        this._lineColor = (Color)mlResource.value;
                        bl2 = true;
                        mlResource.applied = true;
                        break;
                    }
                    case 170: {
                        this._levelSpacing = n3;
                        this._recalcTreeWidth = true;
                        mlResource.applied = true;
                    }
                }
            }
            ++n2;
        }
        if (this._recalcTreeWidth) {
            MlGridColumn mlGridColumn = this.getColumn(1, 0);
            if (mlGridColumn != null) {
                mlGridColumn.widthChanged();
            }
            this._recalcTreeWidth = false;
            bl = true;
        }
        if (bl) {
            this.doLayout(0);
        }
        if (bl || bl2) {
            this.redrawAll();
        }
    }

    protected void createDefaultImages() {
        MlIconMaker mlIconMaker = new MlIconMaker();
        mlIconMaker.setDimensions(16, 16);
        mlIconMaker.setColor('G', -8355712);
        mlIconMaker.setColor('Y', -2039808);
        mlIconMaker.setPixels("   GGGGGGGGG    ");
        mlIconMaker.setPixels("  GWWWWWWWWKK   ");
        mlIconMaker.setPixels("  GWWWWWWWWKWK  ");
        mlIconMaker.setPixels("  GWWWWWWWWKKKK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GWKKKKKKKKWGK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GWKKKKKKKKWGK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GWKKKKKKKKWGK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GWWWWWWWWWWGK ");
        mlIconMaker.setPixels("  GGGGGGGGGGGGK ");
        mlIconMaker.setPixels("   KKKKKKKKKKKK ");
        this._fileImage = mlIconMaker.createImage(this);
        mlIconMaker.clear();
        mlIconMaker.setPixels("                ");
        mlIconMaker.setPixels("                ");
        mlIconMaker.setPixels("     GGGGGG     ");
        mlIconMaker.setPixels("    GYYYYYYG    ");
        mlIconMaker.setPixels("  GGYYYYYYYYGG  ");
        mlIconMaker.setPixels(" GWWWWWWWWWWWYG ");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GWYYYYYYYYYYYGK");
        mlIconMaker.setPixels(" GYYYYYYYYYYYYGK");
        mlIconMaker.setPixels("  GGGGGGGGGGGGKK");
        mlIconMaker.setPixels("   KKKKKKKKKKKK ");
        this._folderImage = mlIconMaker.createImage(this);
        mlIconMaker.clear();
        mlIconMaker.setPixels("                ");
        mlIconMaker.setPixels("                ");
        mlIconMaker.setPixels("     GGGGGG     ");
        mlIconMaker.setPixels("    GYYYYYYG    ");
        mlIconMaker.setPixels("  GGYYYYYYYYGG  ");
        mlIconMaker.setPixels(" GYYYYYYYYYYYYG ");
        mlIconMaker.setPixels(" GYYYYYYYYYYYYGK");
        mlIconMaker.setPixels("GGGGGGGGGGGYYYGK");
        mlIconMaker.setPixels("GWWWWWWWWWYKYYGK");
        mlIconMaker.setPixels("GWYYYYYYYYYKYYGK");
        mlIconMaker.setPixels(" GYYYYYYYYYYKYGK");
        mlIconMaker.setPixels(" GYYYYYYYYYYKYGK");
        mlIconMaker.setPixels("  GYYYYYYYYYYKGK");
        mlIconMaker.setPixels("  GYYYYYYYYYYKGK");
        mlIconMaker.setPixels("   GGGGGGGGGGGKK");
        mlIconMaker.setPixels("    KKKKKKKKKKK ");
        this._folderOpenImage = mlIconMaker.createImage(this);
        this._defaultImagesCreated = true;
    }

    protected void initTreeProperties() {
        this._levelSpacing = 9;
        this._lineColor = new Color(70, 70, 70);
        this._pmColor = new Color(0, 0, 0);
    }

    public int getLevelSpacing() {
        return this._levelSpacing;
    }

    public void setLevelSpacing(int n) {
        this._levelSpacing = n;
        MlGridColumn mlGridColumn = this.getColumn(1, 0);
        if (mlGridColumn != null) {
            mlGridColumn.widthChanged();
        }
        this.doLayout();
        this.draw();
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public void setLineColor(Color color) {
        this._lineColor = color;
        this.draw();
    }

    public Color getPlusMinusColor() {
        return this._pmColor;
    }

    public void setPlusMinus(Color color) {
        this._pmColor = color;
        this.draw();
    }

    public synchronized void addMlTreeListener(MlTreeListener mlTreeListener) {
        MlTreeListener mlTreeListener2;
        MlTreeListener mlTreeListener3 = mlTreeListener2 = this._treeListener;
        MlTreeListener mlTreeListener4 = mlTreeListener;
        this._treeListener = mlTreeListener3 == null ? mlTreeListener4 : (mlTreeListener4 == null ? mlTreeListener3 : new MlEventMulticaster(mlTreeListener3, mlTreeListener4));
    }

    public synchronized void removeMlTreeListener(MlTreeListener mlTreeListener) {
        MlTreeListener mlTreeListener2 = this._treeListener;
        MlTreeListener mlTreeListener3 = mlTreeListener2;
        MlTreeListener mlTreeListener4 = mlTreeListener;
        this._treeListener = (MlTreeListener)(mlTreeListener3 == mlTreeListener4 || mlTreeListener3 == null ? null : (mlTreeListener3 instanceof MlEventMulticaster ? ((MlEventMulticaster)mlTreeListener3).remove(mlTreeListener4) : mlTreeListener3));
    }

    protected void notifyEvent(int n, int n2, int n3, int n4, int n5, AWTEvent aWTEvent, Object object) {
        MlTreeEvent mlTreeEvent = new MlTreeEvent(this, n, n2, n3, n4, n5, aWTEvent, object);
        this.dispatchEvent(mlTreeEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MlTreeEvent) {
            this.processMlTreeEvent((MlTreeEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processMlTreeEvent(MlTreeEvent mlTreeEvent) {
        if (this._treeListener != null) {
            this._treeListener.onTreeEvent(mlTreeEvent);
        }
    }

    public void addRow(int n, boolean bl, String string) {
        this.addRow(n, bl, true, -1, null, string);
    }

    public synchronized void addRow(int n, boolean bl, boolean bl2, int n2, Image image, String string) {
        MlTreeRowDefinition mlTreeRowDefinition = new MlTreeRowDefinition();
        mlTreeRowDefinition.level = n;
        mlTreeRowDefinition.expands = bl;
        mlTreeRowDefinition.isExpanded = bl2;
        mlTreeRowDefinition.image = image;
        mlTreeRowDefinition.string = string;
        MlTreeRowDefinition[] mlTreeRowDefinitionArray = new MlTreeRowDefinition[]{mlTreeRowDefinition};
        this.addRows(mlTreeRowDefinitionArray, n2);
    }

    public synchronized void addRows(MlTreeRowDefinition[] mlTreeRowDefinitionArray, int n) {
        boolean bl;
        int n2 = mlTreeRowDefinitionArray.length;
        if (n2 <= 0) {
            return;
        }
        if (n < 0 || n > this._rowCount) {
            n = this._rowCount;
        }
        if (!(bl = this._layoutFrozen)) {
            this.setValue("layoutFrozen", true);
        }
        this.addRows(1, n, n2);
        MlResources mlResources = new MlResources();
        int n3 = 0;
        while (n3 < n2) {
            MlGridRow mlGridRow = this.getRow(1, n + n3);
            if (mlGridRow != null) {
                MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
                int n4 = mlTreeRowDefinitionArray[n3].level;
                if (n4 < 0) {
                    n4 = 0;
                }
                mlTreeRowValues.level = n4;
                mlTreeRowValues.expands = mlTreeRowDefinitionArray[n3].expands;
                mlTreeRowValues.isExpanded = mlTreeRowDefinitionArray[n3].isExpanded;
                mlTreeRowValues.userObject = mlTreeRowDefinitionArray[n3].userObject;
                mlResources.clear();
                mlResources.add("row", n + n3);
                mlResources.add("column", 0);
                mlResources.add("cellString", mlTreeRowDefinitionArray[n3].string);
                mlResources.add("cellImage", mlTreeRowDefinitionArray[n3].image);
                this.setValues(mlResources);
            }
            ++n3;
        }
        if (!bl) {
            this.setValue("layoutFrozen", false);
        }
    }

    public void collapseRow(int n, boolean bl) {
        this.changeRowState(n, null, false, false, bl);
    }

    public synchronized int countRowChildren(int n) {
        MlGridRow mlGridRow = this.getRow(1, n);
        if (mlGridRow == null) {
            return 0;
        }
        MlTreeRowValues mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
        if (!mlTreeRowValues.expands) {
            return 0;
        }
        int n2 = mlTreeRowValues.level;
        int n3 = n + 1;
        while ((mlGridRow = this.getRow(1, n3)) != null) {
            mlTreeRowValues = (MlTreeRowValues)mlGridRow.getValues();
            if (mlTreeRowValues.level <= n2) break;
            ++n3;
        }
        return n3 - n - 1;
    }

    public void expandRow(int n, boolean bl) {
        this.changeRowState(n, null, true, false, bl);
    }
}

